@extends('layouts.app')

@section('title', 'Notifications')

@section('content')
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">Notifications</h1>
        <div class="flex gap-2">
            <form method="POST" action="{{ route('doctor.notifications.mark-all-read') }}" class="inline">
                @csrf
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                    Mark All as Read
                </button>
            </form>
            <a href="{{ route('doctor.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back</span>
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow">
        @forelse($notifications as $notification)
            <div class="border-b border-gray-200 p-4 sm:p-6 {{ $notification->read_at ? 'bg-white' : 'bg-blue-50' }}">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-start gap-3">
                            @if(isset($notification->data['appointment_id']))
                                <div class="p-2 bg-blue-100 rounded-full">
                                    <i class="fas fa-calendar text-blue-600"></i>
                                </div>
                            @else
                                <div class="p-2 bg-gray-100 rounded-full">
                                    <i class="fas fa-bell text-gray-600"></i>
                                </div>
                            @endif
                            
                            <div class="flex-1">
                                <p class="font-semibold text-gray-800 text-sm sm:text-base {{ $notification->read_at ? '' : 'font-bold' }}">
                                    {{ $notification->data['message'] ?? 'New notification' }}
                                </p>
                                
                                @if(isset($notification->data['appointment_id']))
                                    <div class="mt-2 text-sm text-gray-600">
                                        <p><strong>Patient:</strong> {{ $notification->data['patient_name'] ?? 'N/A' }}</p>
                                        <p><strong>Type:</strong> {{ $notification->data['consultation_type'] ?? 'N/A' }}</p>
                                        @if(isset($notification->data['appointment_date']))
                                            <p><strong>Date:</strong> {{ \Carbon\Carbon::parse($notification->data['appointment_date'])->format('M d, Y H:i') }}</p>
                                        @endif
                                    </div>
                                    <div class="mt-3 flex flex-col sm:flex-row gap-2">
                                        <a href="{{ route('doctor.appointments') }}" class="text-blue-600 hover:text-blue-900 text-sm">
                                            <i class="fas fa-eye"></i> View Appointment
                                        </a>
                                        <a href="{{ route('doctor.video-call', $notification->data['appointment_id']) }}" class="text-green-600 hover:text-green-900 text-sm">
                                            <i class="fas fa-video"></i> Join Video Call
                                        </a>
                                    </div>
                                @endif
                                
                                <p class="text-xs text-gray-500 mt-2">{{ $notification->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    </div>
                    
                    @if(!$notification->read_at)
                        <form method="POST" action="{{ route('doctor.notifications.mark-read', $notification->id) }}" class="ml-4">
                            @csrf
                            <button type="submit" class="text-gray-400 hover:text-gray-600" title="Mark as read">
                                <i class="fas fa-check-circle"></i>
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        @empty
            <div class="p-8 text-center text-gray-500">
                <i class="fas fa-bell-slash text-4xl mb-4"></i>
                <p>No notifications found.</p>
            </div>
        @endforelse
    </div>

    @if($notifications->hasPages())
        <div class="mt-4">
            {{ $notifications->links() }}
        </div>
    @endif
</div>
@endsection

